	function [alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven)
	
	% 	Computes the (symmetric) adaptor coefficients in a lattice wave 
	%	digital filter with lattice branches consisting of branches of first- 
	%	and second-order Richards' sections (series resonance circuits).  
	%	The branches consists of a cascade of these sections using circulators.
	%	a1 is the adaptor coefficient of the input of the first adaptor whereas
	% 	a2 is the adaptor coefficient of the input of the second adaptor.
	
	%	H = (-a1z^2 + (a1-1)a2z + 1)/(z^2 + (a1-1)a2z - a1)
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2009-11-15
	% Modified by: 	 	LW 2014-08-03
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	if abs(imag(Podd(1))) > 1000*eps
		Podd = flipud(Podd);
	end

	if real(Podd) < 100*eps
		alfa_odd(1) = imag(Podd(1));	% Bireciprocal case
	else
		alfa_odd(1) = Podd(1);	
	end
	if mod(length(Podd),2) == 1		% LP or HP case
		for k = 2:2:length(Podd)-1
			alfa_odd(k) = -abs(Podd(k))^2;
			alfa_odd(k+1) = real(2*Podd(k))/(1-alfa_odd(k));
		end
	else		% BP or BS case
		if length(Podd) > 0
			for k = 1:2:length(Podd)-1
				alfa_odd(k) = -abs(Podd(k))^2;
				alfa_odd(k+1) = real(2*Podd(k))/(1-alfa_odd(k));
			end
		else
			alfa_even = [];
		end	
	end
	if length(Peven) > 0
		for k = 1:2:length(Peven)-1
			alfa_even(k) = -abs(Peven(k))^2;
			alfa_even(k+1) = real(2*Peven(k))/(1-alfa_even(k));
		end
	else
		alfa_even = [];
	end	

	
